// Demo_iIDDriver_CEDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo_iIDDriver_CE.h"
#include "Demo_iIDDriver_CEDlg.h"
#include "Reader_Interface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString OutputText, HelpText;
BOOL	SEARCH;
BYTE	Identifier[0x8];	//maximum length of identifier (8byte)

//set port type: 0=standard serial, 1=CompactFlash by elserial, 2=Bluetooth SPP
BYTE			PortType=0;
//and serial port name: 
LPTSTR			lpszPortName=TEXT("COM6:");
//set Interface_Type  125/1356/0x10 (125kHz, 13.56MHz, 125kHz/13.56MHz Mem)
INT32			Interface_Type=1356;
//set TimeOut for iIDDriver functions identify, readbytes and writebytes (10...4999msec)
INT32			TimeOut=500;
//set supported systems for this demo (0xFF -> enable all transponder systems)
INT32			SystemMask = 0xFF;

INT32			from = 0;  //read/write beginning at byte offset 16
INT32			length=12;	//read/write 6 bytes
INT32			main_ver, sub_ver;

DWORD			start, stop;

//----------------------------------------------------------------
//--MICROSENSYS:--------------------------------------------------
//--functions for sound notification------------------------------
//----------------------------------------------------------------
void SuccessBeep()
{
	MessageBeep(MB_OK);
}

void FailBeep()
{
	MessageBeep(MB_ICONEXCLAMATION);
}

/////////////////////////////////////////////////////////////////////////////
// CDemo_iIDDriver_CEDlg dialog

CDemo_iIDDriver_CEDlg::CDemo_iIDDriver_CEDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemo_iIDDriver_CEDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemo_iIDDriver_CEDlg)
	m_CheckEmul = FALSE;
	m_TagAppeared = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemo_iIDDriver_CEDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemo_iIDDriver_CEDlg)
	DDX_Check(pDX, IDC_CHECK_EMULON, m_CheckEmul);
	DDX_Check(pDX, IDC_CHECK_TAGAPPEARED, m_TagAppeared);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemo_iIDDriver_CEDlg, CDialog)
	//{{AFX_MSG_MAP(CDemo_iIDDriver_CEDlg)
	ON_BN_CLICKED(IDC_BUTTON_MSS_READ_INTERFACE_ID, OnButtonMssReadInterfaceId)
	ON_BN_CLICKED(IDC_BUTTON_MSS_Identify, OnBUTTONMSSIdentify)
	ON_BN_CLICKED(IDC_BUTTON_MSS_READBYTES, OnButtonMssReadbytes)
	ON_BN_CLICKED(IDC_BUTTON_MSS_WRITEBYTES, OnButtonMssWritebytes)
	ON_BN_CLICKED(IDC_BUTTON_ABOUT, OnButtonAbout)
	ON_BN_CLICKED(IDC_CHECK_EMULON, OnCheckEmulon)
	ON_BN_CLICKED(IDC_CHECK_TAGAPPEARED, OnCheckTagappeared)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_iIDDriver_CEDlg message handlers

BOOL CDemo_iIDDriver_CEDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen

	// ------------------------------------------------------------
	// MICROSENSYS: -----------------------------------------------
	// ------------------------------------------------------------
	// -dynamic load of the driver functions and first setting of -
	// -port and driver parameters---------------------------------
	// ------------------------------------------------------------

	if (!Init_Driver(TEXT("iiddrv30_pro.dll"))) 
	{
		CDialog::MessageBox(TEXT("Error loading iiddrv30_pro.dll!"),TEXT("DRIVER"),MB_OK);
		CDialog::OnCancel();
		return FALSE;
	}

	//check driver version
	PROC_driver_get_driver_version(&main_ver, &sub_ver);
	if ((main_ver<0x10) || (sub_ver<0xB))
	{
		CDialog::MessageBox(TEXT("Wrong DLL version - too old!"),TEXT("DRIVER"),MB_OK);
		return FALSE;
	}
	
	//set port type
	//and serial port name
	if (PROC_reader_set_port_type(PortType,lpszPortName)!=PortType) 
	{
		CDialog::MessageBox(TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}
	//and interface type
	if (PROC_reader_set_interface_type(Interface_Type)!=0)
	{
		CDialog::MessageBox(TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}
	//and TimeOut
	if (PROC_driver_set_timeout(TimeOut)!=0)
	{
		CDialog::MessageBox(TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

    //set system mask for iID driver mode
	//enable all supported systems
	SystemMask = GROUP_ISO15693 | GROUP_IID_L;
    //enable ISO15693 system only -> maximum speed for preferred system
	//SystemMask = GROUP_ISO15693;
	if (PROC_driver_set_system_mask(SystemMask)!=0) 
	{
		CDialog::MessageBox(TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	//for Infineon my-D: use as standard ISO optional commands, switch to custom by using iso15693_set_myd_custom_mode
	//if (PROC_iso15693_set_myd_custom_mode(1)!=0)
	//{
	//	CDialog::MessageBox(TEXT("ERROR setting parameters !"),TEXT("OPEN INTERFACE"),MB_OK);
	//	return FALSE;
	//}

	//now open the specified interface using 'initialize'
	if (PROC_initialize()!=0)
	{
		CDialog::MessageBox(TEXT("ERROR during 'Open Interface' !"),TEXT("OPEN INTERFACE"),MB_OK);
		return FALSE;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}



void CDemo_iIDDriver_CEDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	// MSS: close communication port before application end
	PROC_terminate();
	CDialog::OnCancel();
}

void CDemo_iIDDriver_CEDlg::OnOK() 
{
	// TODO: Add extra validation here
	// MSS: close communication port before application end
	PROC_terminate();
	CDialog::OnOK();
}

void CDemo_iIDDriver_CEDlg::OnButtonMssReadInterfaceId() 
{
	//--------------------------------------------
	//------ Read Complete Interface-ID ----------
	BYTE Block[0x9];	//maximum storage capacity
	BYTE *pBlock;
	CString Strg, Strg2;

	pBlock=&Block[0];

	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("SEARCHING..."));
	{
		MSS_Result=PROC_read_reader_id(&Reader_Id, pBlock);
		if (MSS_Result!=0) 
		{
			//Error during operation
			FailBeep();
			CDialog::MessageBox(TEXT("ERROR reading Complete Interface-ID !"),TEXT("ERROR"),MB_OK);
			MessageBeep(MB_ICONEXCLAMATION);
		}
		else
		{
			//Operation completed, output
			SuccessBeep();
			OutputText=TEXT("Complete Interface-ID: ");
			for (int i=0; i<=7; i++)
			{
				HelpText.Format(_T("%2X "),Block[i+1]);
				OutputText+=HelpText;
			}
			CDialog::MessageBox(OutputText,TEXT("SUCCESS"),MB_OK);
			MessageBeep(MB_OK);
		}
	}	
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("Demo MICROSENSYS iID(R)-Driver"));
}

void CDemo_iIDDriver_CEDlg::OnBUTTONMSSIdentify() 
{
	BYTE Block[0x9];		//maximum storage capacity
	BYTE *pBlock;

	//--------------------------------------------
	//------ Read Identifier of any transponder --
	//--------------------------------------------

	pBlock=&Block[0];
	
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("SEARCHING..."));
	{	
		MSS_Result=0xFF;int i=0;
		start=GetTickCount();
		MSS_Result=PROC_identify(pBlock);
		stop=GetTickCount();
		if (MSS_Result!=0) 
		{
			//Error during operation
			FailBeep();
			OutputText.Format(_T("Error %2X reading TAG!"),MSS_Result);
			CDialog::MessageBox(OutputText,TEXT("ERROR"),MB_OK);
			MessageBeep(MB_ICONEXCLAMATION);
		}
		else
		{
			//Operation completed, flash LED and output
			SuccessBeep();
			OutputText=TEXT("UID is: ");
			//byte 0=length, byte1..8=data
			//move bytes 1..8 into array identifier for giving to readbytes() and writebytes()
			for (int i=0; i<=7; i++) Identifier[i]=Block[i+1];
			for (i=0; i<Block[0]; i++)
			{
				HelpText.Format(_T("%2X "),Identifier[i]);
				OutputText+=HelpText;
			}
			CDialog::MessageBox(OutputText,TEXT("SUCCESS"),MB_OK);
			MessageBeep(MB_OK);
		}
	}	
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("Demo MICROSENSYS iID(R)-Driver"));
	//showing operation time 
	//see c_set_timeout and c_set_system_mask for increasing the performance
	OutputText.Format(_T("Time elapsed (msec): %2d "),(stop-start));
	CDialog::MessageBox(OutputText,TEXT("INFORMATION"),MB_OK);
}

void CDemo_iIDDriver_CEDlg::OnButtonMssReadbytes() 
{
	BYTE Block[0x3FF];
	BYTE *pBlock;
	CString Strg, Strg2;
	int	year,month,day,hour,minute,second;
	
	//--------------------------------------------
	//---Read Bytes (from..(from+length)) from----
	//---transponder------------------------------
	//--------------------------------------------
	pBlock=&Block[0];

	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("SEARCHING..."));
	{
		start=GetTickCount();
		MSS_Result=PROC_readBytes(Identifier,from,length,pBlock);
		stop=GetTickCount();
		if (MSS_Result!=0) 
		{
			//Error during operation
			FailBeep();
			OutputText.Format(_T("Error %2X reading TAG!"),MSS_Result);
			CDialog::MessageBox(OutputText,TEXT("ERROR"),MB_OK);
			MessageBeep(MB_ICONEXCLAMATION);
		}
		else
		{
			SuccessBeep();
			//Block[0] contains length (6)
			//Block[1..length] contains data
			year=Block[1]+2000;
			month=Block[2];
			day=Block[3];
			hour=Block[4];
			minute=Block[5];
			second=Block[6];

			OutputText.Format(_T("Time Stamp: %d/%d/%d %d:%d:%d read from TAG!"),year,month,day,hour,minute,second);
			CDialog::MessageBox(OutputText,TEXT("SUCCESS"),MB_OK);
			MessageBeep(MB_OK);
		}
	}
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("Demo MICROSENSYS iID(R)-Driver"));
	OutputText.Format(_T("Time elapsed (msec): %2d "),(stop-start));
	CDialog::MessageBox(OutputText,TEXT("INFORMATION"),MB_OK);
}

void CDemo_iIDDriver_CEDlg::OnButtonMssWritebytes() 
{
	BYTE Block[0x3FF];
	BYTE *pBlock;
	CTime theTime;
	BYTE	year,month,day,hour,minute,second;

	pBlock=&Block[0];
	theTime = CTime::GetCurrentTime();
	
	year=theTime.GetYear()-2000;
	month=theTime.GetMonth();
	day=theTime.GetDay();
	hour=theTime.GetHour();
	minute=theTime.GetMinute();
	second=theTime.GetSecond();
	Block[0]=year;
	Block[1]=month;
	Block[2]=day;
	Block[3]=hour;
	Block[4]=minute;
	Block[5]=second;
	int length=6;
	
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("SEARCHING..."));
	{
		start=GetTickCount();
		MSS_Result=PROC_writeBytes(Identifier,from,length,pBlock, FALSE);
		stop=GetTickCount();
		if (MSS_Result!=0) 
		{
			//Error during operation
			FailBeep();
			OutputText.Format(_T("Error %2X writing TAG!"),MSS_Result);
			CDialog::MessageBox(OutputText,TEXT("ERROR"),MB_OK);
			MessageBeep(MB_ICONEXCLAMATION);
		}
		else
		{
			//Operation completed, flash LED and output
			SuccessBeep();
			OutputText.Format(_T("Time Stamp: %d/%d/%d %d:%d:%d written to TAG!"),(year+2000),month,day,hour,minute,second);
			CDialog::MessageBox(OutputText,TEXT("SUCCESS"),MB_OK);
			MessageBeep(MB_OK);
		}
	}
	CDemo_iIDDriver_CEDlg::SetWindowText(TEXT("Demo MICROSENSYS iID(R)-Driver"));
	OutputText.Format(_T("Time elapsed (msec): %2d "),(stop-start));
	CDialog::MessageBox(OutputText,TEXT("INFORMATION"),MB_OK);
}

void CDemo_iIDDriver_CEDlg::OnButtonAbout() 
{
	//Show about dialog
	CDialog::MessageBox(TEXT("Demo iID(R) driver 3000 PRO V0x10.0xB, (c)2007-07 MICROSENSYS"),TEXT("ABOUT"),MB_OK);
}

void CDemo_iIDDriver_CEDlg::OnCheckEmulon() 
{
	//MSS:
	//switch hardware emulation mode ON or OFF
	m_CheckEmul=!m_CheckEmul;
	if (m_CheckEmul==TRUE)
	{
		PROC_emul_On();
		CDialog::MessageBox(TEXT("Hardware emulation mode switched on!"),TEXT("ABOUT"),MB_OK);
	}
	else
	{
		PROC_emul_Off();
		CDialog::MessageBox(TEXT("Hardware emulation mode switched off!"),TEXT("ABOUT"),MB_OK);
	}
}

void CDemo_iIDDriver_CEDlg::OnCheckTagappeared() 
{
	//emulate transponder near receiver
	m_TagAppeared=!m_TagAppeared;
	if (m_TagAppeared==TRUE)
	{
		PROC_tagAppeared();
		CDialog::MessageBox(TEXT("Virtual TAG now present!"),TEXT("ABOUT"),MB_OK);
	}
	else
	{
		PROC_tagDisappeared();
		CDialog::MessageBox(TEXT("Virtual TAG now absent!"),TEXT("ABOUT"),MB_OK);
	}
}
